/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 2002 Parametric Technology Corporation.
	All rights reserved.
*/

#include "stdafx.h"
#include "AddInProject.h"
#include "ProdAddInCls.h"

#define CHECK_RETURN_STATUS(status, ret) \
if (FAILED(status) || !ret) { \
	return status;\
} \

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// IProDAddIn
STDMETHODIMP ProdAddInCls::OnStartUp()
{
	IApplicationPtr pApp(__uuidof(ProDESKTOP));	// creates application object

	IProDExtensibilityPtr prodAdd(pApp);

	IDispatch *pDispatch;
	this->QueryInterface(IID_IDispatch, (void**) &pDispatch);	// gets the disptach pointer
	pDispatch->AddRef();	// increments the reference count

	CComVariant context, handler;
	handler.vt = context.vt = VT_DISPATCH;
	context.pdispVal = handler.pdispVal = pDispatch;

	IUserCommand *pUser;
	prodAdd->AddUserCommand(DesignMenuBar, DesignToolsMenu, -1, CComBSTR("CreateLine"), context, handler, &pUser);	// adds the command in menu 
	pUser->SetPrompt(CComBSTR("CreateLine"));

	return S_OK;
}

STDMETHODIMP ProdAddInCls::OnCloseDown()
{
	IApplicationPtr pApp(__uuidof(ProDESKTOP));	// creates application object

	IProDExtensibilityPtr prodAdd(pApp);

	IUserCommand *pUser;
	prodAdd->GetUserCommand(DesignMenuBar, DesignToolsMenu, CComBSTR("CreateLine"), &pUser);
	prodAdd->RemoveUserCommand(pUser);

	return S_OK;
}

// IUserCommandHandler
STDMETHODIMP ProdAddInCls::OnCommand(IUserCommand *userCommand)
{
	IApplicationPtr pApp(__uuidof(ProDESKTOP));	// creates application object

	IGraphicDocument *pGraphicDoc = NULL;
	HRESULT status = NOERROR;

	status = pApp->GetActiveDoc(&pGraphicDoc);
	CHECK_RETURN_STATUS(status, pGraphicDoc);

	ISketch *activeSketch = NULL;
	status = pGraphicDoc->GetActiveSketch(&activeSketch);
	CHECK_RETURN_STATUS(status, activeSketch);

	IDispatch *disp = NULL;
	status = pApp->GetClass(CComBSTR("Vector"), &disp);
	CHECK_RETURN_STATUS(status, disp);

	IVectorClass *vecCls = NULL;
	status = disp->QueryInterface(IID_IVectorClass, (void **)&vecCls);
	CHECK_RETURN_STATUS(status, vecCls);

	IVector *start = NULL, *end = NULL; 
	vecCls->CreateVector(0.010, 0.050, 0.0, &start);	// all numbers are in meters
	vecCls->CreateVector(0.090, 0.010, 0.0, &end);

	disp = NULL;
	status = pApp->GetClass(CComBSTR("BasicStraight"), &disp);
	CHECK_RETURN_STATUS(status, disp);

	IBasicStraightClass *bStrCls = NULL;
	status = disp->QueryInterface(IID_IBasicStraightClass, (void **)&bStrCls);
	CHECK_RETURN_STATUS(status, bStrCls);

	IBasicStraight *basicStraight = NULL;
	status = bStrCls->CreateBasicStraightTwoPoints(start, end, &basicStraight);
	CHECK_RETURN_STATUS(status, basicStraight);

	ICurve *curve = NULL;
	status = basicStraight->QueryInterface(IID_ICurve, (void **)&curve);
	CHECK_RETURN_STATUS(status, curve);

	ILine *line = NULL;
	status = activeSketch->CreateLine(curve, &line);

	return S_OK;
}

STDMETHODIMP ProdAddInCls::OnUpdateCommand(IUserCommand *userCommand)
{
	return E_NOTIMPL;
}



